function [xss, yss, t1ss, that,sss, Pmatss, retcode] ...
    = bfor_endogenous_ms_solver_steadystate(f, Pmat, vars, steady, THETA, nTHETA)

% -- Dimensions -- %
ny = length(vars.yvars);
nx = length(vars.xvars);
ne = length(vars.eps);
ns = size(Pmat,1);

% -- Statey State Equations -- %
fss = subs(f,[vars.yvarsp' vars.yvars'  vars.xvars'  vars.xlag'   vars.eps'    vars.epsp'   vars.t1vars'  vars.t1varsp' THETA'] ,...
             [vars.yvarss' vars.yvarss' vars.xvarss' vars.xvarss' zeros(ne,1)' zeros(ne,1)' vars.t1varss' vars.t1varss' nTHETA']);


% -- Initialization -- %
options = optimoptions('fsolve','MaxFunctionEvaluations',10000,'MaxIterations',1000,'display','off');
Pmatss  = 1/ns*ones(ns,ns);
check   = Inf;
iter    = 0;

% -- Fixed Point Procedure -- %
while check > 1e-10 && iter < 100
    % Increment iteration
    iter    = iter + 1;    
    Pmatss0 = Pmatss;
    
    % Find ergodic distribution across regimes
    Amat    = [Pmatss'-eye(ns); ones(1,ns)];
    sss     = (Amat'*Amat)\Amat'*[zeros(ns,1);1];
    
    % Find theta1 in steady state
    temp    = zeros(size(vars.t1varss));
    for ii = 1:ns
        temp = temp + sss(ii)*str2sym(strrep(string(vars.t1vars),'_s',['_' num2str(ii)]));
    end
    t1ss = double(subs(temp,THETA,nTHETA));
    
    % Plug in steady state and parameter values
    fss1 = subs(fss,vars.t1varss,t1ss);
    fss1 = subs(fss1,vars.t2vars, str2sym(strrep(string(vars.t2vars),'_s',['_' num2str(1)])));	% this setting s->1 is abitrary for these parameters
    fss1 = subs(fss1,vars.t2varsp,str2sym(strrep(string(vars.t2vars),'_s',['_' num2str(1)])));  % since they drop out in steady state
    fss1 = subs(fss1,THETA,nTHETA);

    % Initial guess for steady state
    x0 =  double(subs(subs([steady.yss;steady.xss],vars.t1varss,t1ss),THETA,nTHETA));
    if length(x0) ~= length(f); x0 = zeros(length(f),1); disp('Bad Dimensions of Initial Guess'); end
    
    % Solve steady state
    [output,fval] = fsolve(@(x) ssolver(fss1,vars.yvarss,vars.xvarss,x),x0,options);
    
    % save output 
    yss = output(1:ny);
    xss = output(ny+1:ny+nx);
    Pmatss = eval(subs(Pmat,[vars.yvars;THETA],[yss;nTHETA]));
    check = max(max(abs(Pmatss-Pmatss0)));
end

% compute thetahat 
that = NaN(length(vars.tvars),length(Pmat));
for ii = 1:length(Pmatss)
    that(:,ii) = double(subs(subs([vars.t1vars-t1ss;zeros(length(vars.t2vars),1)],vars.tvars,str2sym(strrep(string(vars.tvars),'_s',['_' num2str(ii)]))),THETA,nTHETA));
end

% output
if check < 1e-10
    retcode = 1;
    disp(['Steady state converged after ' num2str(iter) ' iterations, norm = ' num2str(check), ', fsolve accuracy = ' num2str(max(abs(fval)))]);
else
    retcode = 0;
    disp('Steady state not converged');
end
    
end

% steady state solver
function resid = ssolver(fss1,yvarss,xvarss,valvec)
    resid = eval(subs(fss1,[yvarss;xvarss],valvec));
end